IF OBJECT_ID('p_plug_Farma_tipoRegistro_trintaEUm') IS NOT NULL
	BEGIN
		DROP PROCEDURE p_plug_Farma_tipoRegistro_trintaEUm
	END
 
GO 
CREATE PROCEDURE p_plug_Farma_tipoRegistro_trintaEUm (@filial INT , @data   DATE , @cd_emp INT  = 1, @CargaInicial tinyint=0) AS
BEGIN


	DECLARE @DataInicio DATE
	DECLARE @DataFim DATE
	DECLARE @NaoEnviarCargaInicial INT = 0

	IF @CargaInicial = 1
	BEGIN
		SET @DataInicio = CONVERT(DATE,GETDATE()-90)
		SET @DataFim = CONVERT(DATE,GETDATE()-1)
		SET @NaoEnviarCargaInicial = 1
	END
	ELSE
	BEGIN
		SET @DataInicio = @data
		SET @DataFim = @data
	END


	SELECT 31 AS tipoRegistro,
			   P.CD_CTR as numeroRegistro, /*Realinhar com Iuri = codigo despesa do 30*/
			   ISNULL(REPLACE(CONVERT(VARCHAR(10), D.DT_CAD, 103), '/', ''),'') as dataUltimaAtualizacao,
			   CONCAT(d.CD_EMP, d.CD_FILIAL, d.CD_PG_CRED, d.CD_DP_LANC) numeroPagamento,
				ISNULL(REPLACE(CONVERT(VARCHAR(10), D.dt_pag, 103), '/', ''),'') as dataPagamento,
				1 AS status, /*conferir depois com Dja se não tem alguma ligação para estorno*/
				ISNULL(D2.VLR_PGTO,0) AS valorPagamento,
				DATEDIFF(DD,P.DT_VENCTO, D.dt_pag) AS quantidadeDiasAtraso,
			   CASE 
					WHEN p.COB = 0
						THEN '07'--'BANCÁRIO'
					WHEN p.COB = 1
						THEN '10'--'CARTEIRA'
					WHEN p.COB = 2
						THEN '02'--'CHEQUE'
					WHEN p.COB = 3
						THEN '99'--'OUTROS'
					WHEN p.COB = 4
						THEN '07'--'DEPÓSITO'
					WHEN p.COB = 5
						THEN '07'--'BOLETO'
					ELSE '99'
					END tipoPagamento,
				CASE 
					WHEN p.COB = 0
						THEN 'BANCÁRIO'
					WHEN p.COB = 1
						THEN 'CARTEIRA'
					WHEN p.COB = 2
						THEN 'CHEQUE'
					WHEN p.COB = 3
						THEN 'OUTROS'
					WHEN p.COB = 4
						THEN 'DEPÓSITO'
					WHEN p.COB = 5
						THEN 'BOLETO'
					ELSE 'OUTROS'
					END descricaoPagamento,
					CONCAT(d.CD_EMP, d.CD_FILIAL, d.CD_PG_CRED, d.CD_DP_LANC) AS numeroDocumento,
					ISNULL(BC.DS_BC, '') AS nomeBanco,
					ISNULL(CNT.AGC_CNT, 0) AS numeroAgencia,
					ISNULL(CNT.NR_CNT_EDI, '') AS numeroConta,
					ISNULL(P.NR_TIT,'') AS titulo
		FROM PG_CRED P
		INNER JOIN PG_DEB D ON  D.CD_EMP = P.CD_EMP
								AND D.CD_FILIAL = P.CD_FILIAL
								AND D.CD_PG_CRED = P.CD_PG_CRED
		LEFT JOIN BC_CONTAS CNT ON CNT.CD_CNT = D.CD_CNT AND CNT.CD_EMP = D.CD_EMP
		LEFT JOIN BC_BANCO BC ON BC.CD_BC = CNT.CD_BC
		CROSS APPLY (SELECT (SUM(ISNULL(D2.VL_PGTO, 0)) + SUM(ISNULL(D2.VL_JUR, 0))) - (SUM(ISNULL(D2.VL_DESC, 0)) + SUM(ISNULL(D2.VL_IMP, 0)) + SUM(ISNULL(D2.VLR_DEVOLUCAO, 0))) AS VLR_PGTO
					 FROM PG_DEB D2
					 WHERE D.CD_EMP = D2.CD_EMP
							AND D.CD_FILIAL = D2.CD_FILIAL
							AND D.CD_PG_CRED = D2.CD_PG_CRED
							AND D.CD_DP_LANC = D2.CD_DP_LANC
					 GROUP BY D2.CD_EMP, D2.CD_FILIAL, D2.CD_PG_CRED) D2
		WHERE CONVERT(DATE,D.dt_pag) BETWEEN @DataInicio AND @DataFim
		AND p.CD_FILIAL = @filial
		AND p.CD_EMP = @cd_emp
		AND 0 = @NaoEnviarCargaInicial /*Solicitado pelo Julio*/
		ORDER BY DT_EMIS DESC
END